/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.chat.ChatConstants;
import net.creeperhost.minetogether.chat.ChatStatistics;
import net.creeperhost.minetogether.chat.MessageDropdownOption;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.ChatScrollList;
import net.creeperhost.minetogether.chat.gui.FriendRequestScreen;
import net.creeperhost.minetogether.chat.gui.FriendsListScreen;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.gui.SettingsScreen;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.irc.IrcState;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.polylib.gui.DropdownButton;
import net.creeperhost.minetogether.polylib.gui.IconButton;
import net.creeperhost.minetogether.polylib.gui.StringButton;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ChatScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Screen parent;
    @Nullable
    private IrcChannel channel;
    @Nullable
    private ChatScrollList chatList;
    @Nullable
    private EditBox sendEditBox;
    @Nullable
    private StringButton connectionStatus;
    private Button friendsList;
    private DropdownButton<MessageDropdownOption> messageDropdownButton;
    @Nullable
    private Message clickedMessage;
    private Button newUserButton;
    private Button disableButton;
    private boolean newUser = MineTogetherChat.isNewUser();

    public ChatScreen(Screen parent) {
        super((Component)new TranslatableComponent("minetogether:screen.chat.title"));
        this.parent = parent;
    }

    public void attach(IrcChannel channel) {
        this.channel = channel;
        if (this.chatList != null) {
            this.chatList.attach(channel);
        }
    }

    protected void m_7856_() {
        assert (this.f_96541_ != null);
        this.f_96541_.f_91068_.m_90926_(true);
        this.chatList = new ChatScrollList(this.f_96541_, this.f_96543_ - 20, this.f_96544_ - 50, 30, this.f_96544_ - 50);
        this.chatList.m_93507_(10);
        this.chatList.m_93410_(this.chatList.m_93518_());
        this.channel = MineTogetherChat.CHAT_STATE.ircClient.getPrimaryChannel();
        if (this.channel != null) {
            this.attach(this.channel);
        }
        boolean shouldFocusEditBox = this.sendEditBox == null || this.sendEditBox.m_93696_();
        this.sendEditBox = new EditBox(this.f_96541_.f_91062_, 11, this.f_96544_ - 48, this.f_96543_ - 22, 20, this.sendEditBox, TextComponent.f_131282_);
        this.sendEditBox.m_94178_(shouldFocusEditBox);
        this.sendEditBox.m_94199_(256);
        this.m_142416_((GuiEventListener)this.chatList);
        this.m_142416_((GuiEventListener)this.sendEditBox);
        this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ - 124, 5, 3, Constants.WIDGETS_SHEET, e -> this.f_96541_.m_91152_((Screen)new SettingsScreen(this))));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 100 - 5, this.f_96544_ - 5 - 20, 100, 20, (Component)new TranslatableComponent("minetogether:button.cancel"), button -> this.f_96541_.m_91152_(this.parent)));
        this.connectionStatus = new StringButton(8, this.f_96544_ - 20, 70, 20, false, () -> {
            IrcState state = MineTogetherChat.CHAT_STATE.ircClient.getState();
            return new TextComponent(ChatConstants.STATE_FORMAT_LOOKUP.get((Object)state) + "\u2022 " + ChatFormatting.WHITE + ChatConstants.STATE_DESC_LOOKUP.get((Object)state));
        }, button -> {
            if (MineTogetherChat.CHAT_STATE.ircClient.getState() == IrcState.BANNED) {
                this.f_96541_.m_91152_((Screen)new ConfirmScreen(t -> {
                    if (t) {
                        Util.m_137581_().m_137646_("https://minetogether.io/profile/standing");
                    }
                    this.f_96541_.m_91152_((Screen)this);
                }, (Component)new TranslatableComponent("minetogether:screen.banned.line1"), (Component)new TranslatableComponent("minetogether:screen.banned.line2")));
            }
        });
        this.m_142416_((GuiEventListener)this.connectionStatus);
        this.friendsList = new Button(5, 5, 100, 20, (Component)new TranslatableComponent("minetogether:button.friends"), e -> this.f_96541_.m_91152_((Screen)new FriendsListScreen(this)));
        this.m_142416_((GuiEventListener)this.friendsList);
        this.messageDropdownButton = (DropdownButton)this.m_142416_((GuiEventListener)new DropdownButton<MessageDropdownOption>(100, 20, clicked -> {
            assert (this.clickedMessage != null);
            assert (this.clickedMessage.sender != null);
            switch (clicked) {
                case MUTE: {
                    this.clickedMessage.sender.mute();
                    break;
                }
                case ADD_FRIEND: {
                    this.f_96541_.m_91152_((Screen)new FriendRequestScreen(this, this.clickedMessage.sender, FriendRequestScreen.Type.REQUEST));
                    break;
                }
                case MENTION: {
                    Object val = this.sendEditBox.m_94155_();
                    if (!((String)val).isEmpty() && ((String)val).charAt(((String)val).length() - 1) != ' ') {
                        val = (String)val + " ";
                    }
                    this.sendEditBox.m_94144_((String)val + this.clickedMessage.sender.getDisplayName());
                    break;
                }
                default: {
                    LOGGER.info("Dropdown action not currently implemented! {}", clicked);
                }
            }
        }));
        this.messageDropdownButton.setEntries(MessageDropdownOption.VALUES);
        if (this.newUser) {
            ChatStatistics.pollStats();
            this.newUserButton = (Button)this.m_7787_((GuiEventListener)new Button(this.f_96543_ / 2 - 150, 75 + this.f_96544_ / 4, 300, 20, (Component)new TextComponent("Join " + ChatStatistics.onlineCount + " online users now!"), e -> {
                MineTogetherChat.setNewUserResponded();
                this.f_96541_.m_91152_((Screen)new ChatScreen(this.parent));
            }));
            this.disableButton = (Button)this.m_7787_((GuiEventListener)new Button(this.f_96543_ / 2 - 150, 95 + this.f_96544_ / 4, 300, 20, (Component)new TextComponent("Don't ask me again."), e -> {
                MineTogetherChat.disableChat();
                Config.instance().chatEnabled = false;
                Config.save();
                MineTogetherChat.setNewUserResponded();
                this.f_96541_.m_91152_(this.parent);
            }));
        }
    }

    protected void m_169413_() {
        if (this.chatList != null) {
            this.chatList.removed();
        }
        super.m_169413_();
    }

    public void m_7861_() {
        if (this.chatList != null) {
            this.chatList.removed();
        }
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.connectionStatus != null) {
            this.connectionStatus.tick();
        }
        if (this.newUser) {
            this.sendEditBox.m_94178_(false);
            this.sendEditBox.m_94186_(false);
            this.sendEditBox.m_94167_("");
            return;
        }
        IrcState state = MineTogetherChat.CHAT_STATE.ircClient.getState();
        if (state != IrcState.CONNECTED) {
            this.sendEditBox.m_94178_(false);
            this.sendEditBox.m_94186_(false);
            this.sendEditBox.m_94167_(new TranslatableComponent(ChatConstants.STATE_SUGGESTION_LOOKUP.get((Object)state)).getString());
            return;
        }
        this.sendEditBox.m_94186_(true);
        this.sendEditBox.m_94167_("");
    }

    public void m_6305_(PoseStack pStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(1);
        super.m_6305_(pStack, mouseX, mouseY, partialTicks);
        ChatScreen.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        if (this.newUser) {
            pStack.m_85836_();
            pStack.m_85837_(0.0, 0.0, 100.0);
            ChatScreen.m_93172_((PoseStack)pStack, (int)10, (int)this.chatList.getTop(), (int)(this.f_96543_ - 10), (int)this.chatList.getHeight(), (int)-1728053248);
            ChatScreen.m_93172_((PoseStack)pStack, (int)10, (int)this.chatList.getTop(), (int)(this.f_96543_ - 10), (int)this.chatList.getHeight(), (int)-1728053248);
            ChatScreen.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether:new_user.1"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 4 + 25), (int)0xFFFFFF);
            ChatScreen.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether:new_user.2"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 4 + 35), (int)0xFFFFFF);
            ChatScreen.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether:new_user.3"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 4 + 45), (int)0xFFFFFF);
            ChatScreen.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether:new_user.4", new Object[]{ChatStatistics.userCount}), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 4 + 55), (int)0xFFFFFF);
            this.newUserButton.m_6305_(pStack, mouseX, mouseY, partialTicks);
            this.disableButton.m_6305_(pStack, mouseX, mouseY, partialTicks);
            pStack.m_85849_();
        }
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        String trimmedMessage;
        assert (this.sendEditBox != null);
        if (!(key != 257 && key != 335 || (trimmedMessage = this.sendEditBox.m_94155_().trim()).isEmpty())) {
            this.sendEditBox.m_94144_("");
            if (this.channel != null) {
                this.channel.sendMessage(trimmedMessage);
            }
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean b = super.m_6375_(mouseX, mouseY, button);
        if (b) {
            return true;
        }
        if (!this.chatList.m_5953_(mouseX, mouseY)) {
            return false;
        }
        if (this.newUser) {
            return false;
        }
        ChatScrollList.ChatLine line = this.chatList.getEntry(mouseX, mouseY);
        if (line == null) {
            return false;
        }
        if (line.message.sender == null) {
            return false;
        }
        if (line.message.sender == MineTogetherChat.getOurProfile()) {
            return false;
        }
        Style style = this.f_96541_.f_91062_.m_92865_().m_92338_(line.formattedMessage, (int)mouseX);
        if (style == null || style.m_131182_() == null) {
            return false;
        }
        ClickEvent event = style.m_131182_();
        if (event.m_130623_().equals("CE:CLICK_NAME")) {
            this.clickedMessage = line.message;
            this.messageDropdownButton.openAt(mouseX, mouseY);
            return true;
        }
        return false;
    }
}

